﻿//////////////////////////////////////////////
// TestClassObserverInformation.h
// 
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Includes ---------------------------------

// nkDebug
#include "../../Dll/DllDefines.h"

// nkLog
#include <NilkinsMemory/Containers/String.h>
#include <NilkinsMemory/Containers/StringView.h>

/// Structure --------------------------------

namespace nkDebug
{
	class DLL_NKDEBUG_EXPORT TestClassObserverInformation final
	{
		public :

			// Constructor, destructor
			TestClassObserverInformation () noexcept ;

			// Getters
			nkMemory::StringView getName () const ;
			unsigned int getClassTotalFunctionCount () const ;
			unsigned int getClassFilteredFunctionCount () const ;

			// Setters
			void setName (nkMemory::StringView value) ;
			void setClassTotalFunctionCount (unsigned int value) ;
			void setClassFilteredFunctionCount (unsigned int value) ;

		private :

			// Attributes
			nkMemory::String _name ;

			unsigned int _classTotalFunctionCount ;
			unsigned int _classFilteredFunctionCount ;
	} ;
}